/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl;

import Krasnodar.rockstarnew.framework.base.CustomComponent;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.framework.objects.MouseButton;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.setting.settings.BezierSetting;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.MenuSettingComponent;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.game.cursor.CursorType;
import Krasnodar.rockstarnew.utility.game.cursor.CursorUtility;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import net.minecraft.class_241;

public class BezierSettingComponent
extends MenuSettingComponent<BezierSetting> {
    private final Animation startX = new Animation(500L, Easing.BAKEK_PAGES);
    private final Animation startY = new Animation(500L, Easing.BAKEK_PAGES);
    private final Animation endX = new Animation(500L, Easing.BAKEK_PAGES);
    private final Animation endY = new Animation(500L, Easing.BAKEK_PAGES);
    private boolean dragStart;
    private boolean dragEnd;

    public BezierSettingComponent(BezierSetting setting, CustomComponent parent) {
        super(setting, parent);
    }

    @Override
    protected void renderComponent(UIContext context) {
        float x = this.x + 9.0f;
        float y = this.y + 2.0f;
        float width = this.width - 18.0f;
        Font nameFont = Fonts.REGULAR.getFont(8.0f);
        float leftPadding = 10.0f;
        float nameHeight = Fonts.REGULAR.getFont(7.0f).height();
        this.hoverAnimation.update(this.isHovered(context.getMouseX(), context.getMouseY()));
        float offset = 3.0f;
        float boxX = x - 1.0f + offset;
        float boxY = y + 17.0f + offset;
        float boxWidth = width + 2.0f - offset * 2.0f;
        float boxHeight = this.height - 10.0f - 17.0f - offset * 2.0f;
        context.drawRoundedRect(boxX - offset, boxY - offset, boxWidth + offset * 2.0f, boxHeight + offset * 2.0f, BorderRadius.all(6.0f), Colors.getBackgroundColor().withAlpha(76.5f));
        context.drawRoundedRect(boxX + this.startX.getValue() * boxWidth - 3.0f, boxY + this.startY.getValue() * boxHeight - 3.0f, 6.0f, 6.0f, BorderRadius.all(6.0f), Colors.WHITE.withAlpha(255.0f));
        context.drawRoundedRect(boxX + this.endX.getValue() * boxWidth - 3.0f, boxY + this.endY.getValue() * boxHeight - 3.0f, 6.0f, 6.0f, BorderRadius.all(6.0f), Colors.WHITE.withAlpha(255.0f));
        class_241 anchorStart = new class_241(boxX, boxY + boxHeight);
        class_241 controlStart = new class_241(boxX + this.startX.getValue() * boxWidth, boxY + this.startY.getValue() * boxHeight);
        class_241 controlEnd = new class_241(boxX + this.endX.getValue() * boxWidth, boxY + this.endY.getValue() * boxHeight);
        class_241 anchorEnd = new class_241(boxX + boxWidth, boxY);
        context.drawBezier(anchorStart, controlStart, controlEnd, anchorEnd, ColorRGBA.WHITE, 50);
        context.drawLine(anchorStart, controlStart, Colors.WHITE.mulAlpha(0.5f));
        context.drawLine(anchorEnd, controlEnd, Colors.WHITE.mulAlpha(0.5f));
        context.drawFadeoutText(nameFont, Localizator.translate(((BezierSetting)this.setting).getName()), this.x + leftPadding, y + 11.0f - nameFont.height(), Colors.getTextColor().withAlpha(255.0f * (0.75f + 0.25f * this.hoverAnimation.getValue())), 0.8f, 1.0f, this.getParent().getWidth() - leftPadding - 10.0f);
        if (this.isHovered(context.getMouseX(), context.getMouseY())) {
            CursorUtility.set(CursorType.HAND);
        }
        if (this.dragStart) {
            float xValue = GuiUtility.getSliderValue(0.0f, 1.0f, boxX, boxWidth, context.getMouseX());
            float yValue = GuiUtility.getSliderValueWithoutClamp(0.0f, 1.0f, boxY, boxHeight, context.getMouseY());
            ((BezierSetting)this.setting).start(new class_241(xValue, Math.clamp(yValue, -0.5f, 1.5f)));
            CursorUtility.set(CursorType.CROSSHAIR);
        } else if (this.dragEnd) {
            float xValue = GuiUtility.getSliderValue(0.0f, 1.0f, boxX, boxWidth, context.getMouseX());
            float yValue = GuiUtility.getSliderValueWithoutClamp(0.0f, 1.0f, boxY, boxHeight, context.getMouseY());
            ((BezierSetting)this.setting).end(new class_241(xValue, Math.clamp(yValue, -0.5f, 1.5f)));
            CursorUtility.set(CursorType.CROSSHAIR);
        }
        this.startX.setValue(((BezierSetting)this.setting).start().field_1343);
        this.startY.setValue(((BezierSetting)this.setting).start().field_1342);
        this.endX.setValue(((BezierSetting)this.setting).end().field_1343);
        this.endY.setValue(((BezierSetting)this.setting).end().field_1342);
    }

    @Override
    public void drawSplit(UIContext context) {
        float separatorHeight = 0.5f;
        context.drawRect(this.x, this.y + this.height, this.width, separatorHeight, Colors.getTextColor().withAlpha(5.1f));
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        float x = this.x + 9.0f;
        float y = this.y + 2.0f;
        float width = this.width - 18.0f;
        if (this.isHovered(mouseX, mouseY)) {
            float endDist;
            float boxX = x - 1.0f;
            float boxY = y + 17.0f;
            float boxWidth = width + 2.0f;
            float boxHeight = this.height - 10.0f - 17.0f;
            class_241 mouse = new class_241(GuiUtility.getPercent((float)mouseX, boxX, boxX + boxWidth), GuiUtility.getPercent((float)mouseY, boxY, boxY + boxHeight));
            float startDist = this.distance(((BezierSetting)this.setting).start(), mouse);
            if (startDist < (endDist = this.distance(((BezierSetting)this.setting).end(), mouse))) {
                this.dragStart = true;
            } else {
                this.dragEnd = true;
            }
        }
        super.onMouseClicked(mouseX, mouseY, button);
    }

    public float distance(class_241 vec, class_241 vec2) {
        float f = vec.field_1343 - vec2.field_1343;
        float g = vec.field_1342 - vec2.field_1342;
        return (float)Math.sqrt(f * f + g * g);
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, MouseButton button) {
        this.dragStart = false;
        this.dragEnd = false;
        super.onMouseReleased(mouseX, mouseY, button);
    }

    @Override
    public float getHeight() {
        this.height = this.width - 14.0f;
        return this.height;
    }
}

